﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/ActionSummary.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace QBusiness {
namespace Model {

ActionSummary::ActionSummary(JsonView jsonValue) { *this = jsonValue; }

ActionSummary& ActionSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("actionIdentifier")) {
    m_actionIdentifier = jsonValue.GetString("actionIdentifier");
    m_actionIdentifierHasBeenSet = true;
  }
  if (jsonValue.ValueExists("displayName")) {
    m_displayName = jsonValue.GetString("displayName");
    m_displayNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("instructionExample")) {
    m_instructionExample = jsonValue.GetString("instructionExample");
    m_instructionExampleHasBeenSet = true;
  }
  if (jsonValue.ValueExists("description")) {
    m_description = jsonValue.GetString("description");
    m_descriptionHasBeenSet = true;
  }
  return *this;
}

JsonValue ActionSummary::Jsonize() const {
  JsonValue payload;

  if (m_actionIdentifierHasBeenSet) {
    payload.WithString("actionIdentifier", m_actionIdentifier);
  }

  if (m_displayNameHasBeenSet) {
    payload.WithString("displayName", m_displayName);
  }

  if (m_instructionExampleHasBeenSet) {
    payload.WithString("instructionExample", m_instructionExample);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  return payload;
}

}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
