﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/qbusiness/model/BatchPutDocumentResult.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

BatchPutDocumentResult::BatchPutDocumentResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

BatchPutDocumentResult& BatchPutDocumentResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("failedDocuments")) {
    Aws::Utils::Array<JsonView> failedDocumentsJsonList = jsonValue.GetArray("failedDocuments");
    for (unsigned failedDocumentsIndex = 0; failedDocumentsIndex < failedDocumentsJsonList.GetLength(); ++failedDocumentsIndex) {
      m_failedDocuments.push_back(failedDocumentsJsonList[failedDocumentsIndex].AsObject());
    }
    m_failedDocumentsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
