﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/qbusiness/model/CreateChatResponseConfigurationResult.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateChatResponseConfigurationResult::CreateChatResponseConfigurationResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

CreateChatResponseConfigurationResult& CreateChatResponseConfigurationResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("chatResponseConfigurationId")) {
    m_chatResponseConfigurationId = jsonValue.GetString("chatResponseConfigurationId");
    m_chatResponseConfigurationIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("chatResponseConfigurationArn")) {
    m_chatResponseConfigurationArn = jsonValue.GetString("chatResponseConfigurationArn");
    m_chatResponseConfigurationArnHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
