﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/CreateSubscriptionRequest.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateSubscriptionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_principalHasBeenSet) {
    payload.WithObject("principal", m_principal.Jsonize());
  }

  if (m_typeHasBeenSet) {
    payload.WithString("type", SubscriptionTypeMapper::GetNameForSubscriptionType(m_type));
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  return payload.View().WriteReadable();
}
