﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/qbusiness/model/ListDataAccessorsResult.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDataAccessorsResult::ListDataAccessorsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListDataAccessorsResult& ListDataAccessorsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("dataAccessors")) {
    Aws::Utils::Array<JsonView> dataAccessorsJsonList = jsonValue.GetArray("dataAccessors");
    for (unsigned dataAccessorsIndex = 0; dataAccessorsIndex < dataAccessorsJsonList.GetLength(); ++dataAccessorsIndex) {
      m_dataAccessors.push_back(dataAccessorsJsonList[dataAccessorsIndex].AsObject());
    }
    m_dataAccessorsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
