﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/qbusiness/model/ListDocumentsResult.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDocumentsResult::ListDocumentsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListDocumentsResult& ListDocumentsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("documentDetailList")) {
    Aws::Utils::Array<JsonView> documentDetailListJsonList = jsonValue.GetArray("documentDetailList");
    for (unsigned documentDetailListIndex = 0; documentDetailListIndex < documentDetailListJsonList.GetLength();
         ++documentDetailListIndex) {
      m_documentDetailList.push_back(documentDetailListJsonList[documentDetailListIndex].AsObject());
    }
    m_documentDetailListHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
