﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/UpdatePluginRequest.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdatePluginRequest::SerializePayload() const {
  JsonValue payload;

  if (m_displayNameHasBeenSet) {
    payload.WithString("displayName", m_displayName);
  }

  if (m_stateHasBeenSet) {
    payload.WithString("state", PluginStateMapper::GetNameForPluginState(m_state));
  }

  if (m_serverUrlHasBeenSet) {
    payload.WithString("serverUrl", m_serverUrl);
  }

  if (m_customPluginConfigurationHasBeenSet) {
    payload.WithObject("customPluginConfiguration", m_customPluginConfiguration.Jsonize());
  }

  if (m_authConfigurationHasBeenSet) {
    payload.WithObject("authConfiguration", m_authConfiguration.Jsonize());
  }

  return payload.View().WriteReadable();
}
