﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/rds/model/DescribeDBProxyTargetsResult.h>

#include <utility>

using namespace Aws::RDS::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

DescribeDBProxyTargetsResult::DescribeDBProxyTargetsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

DescribeDBProxyTargetsResult& DescribeDBProxyTargetsResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "DescribeDBProxyTargetsResult")) {
    resultNode = rootNode.FirstChild("DescribeDBProxyTargetsResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode targetsNode = resultNode.FirstChild("Targets");
    if (!targetsNode.IsNull()) {
      XmlNode targetsMember = targetsNode.FirstChild("member");
      m_targetsHasBeenSet = !targetsMember.IsNull();
      while (!targetsMember.IsNull()) {
        m_targets.push_back(targetsMember);
        targetsMember = targetsMember.NextNode("member");
      }

      m_targetsHasBeenSet = true;
    }
    XmlNode markerNode = resultNode.FirstChild("Marker");
    if (!markerNode.IsNull()) {
      m_marker = Aws::Utils::Xml::DecodeEscapedXmlText(markerNode.GetText());
      m_markerHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::RDS::Model::DescribeDBProxyTargetsResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
