﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/rds/model/DescribeDBSnapshotsResult.h>

#include <utility>

using namespace Aws::RDS::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

DescribeDBSnapshotsResult::DescribeDBSnapshotsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

DescribeDBSnapshotsResult& DescribeDBSnapshotsResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "DescribeDBSnapshotsResult")) {
    resultNode = rootNode.FirstChild("DescribeDBSnapshotsResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode markerNode = resultNode.FirstChild("Marker");
    if (!markerNode.IsNull()) {
      m_marker = Aws::Utils::Xml::DecodeEscapedXmlText(markerNode.GetText());
      m_markerHasBeenSet = true;
    }
    XmlNode dBSnapshotsNode = resultNode.FirstChild("DBSnapshots");
    if (!dBSnapshotsNode.IsNull()) {
      XmlNode dBSnapshotsMember = dBSnapshotsNode.FirstChild("DBSnapshot");
      m_dBSnapshotsHasBeenSet = !dBSnapshotsMember.IsNull();
      while (!dBSnapshotsMember.IsNull()) {
        m_dBSnapshots.push_back(dBSnapshotsMember);
        dBSnapshotsMember = dBSnapshotsMember.NextNode("DBSnapshot");
      }

      m_dBSnapshotsHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::RDS::Model::DescribeDBSnapshotsResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
