﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rds/model/StartActivityStreamRequest.h>

using namespace Aws::RDS::Model;
using namespace Aws::Utils;

Aws::String StartActivityStreamRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=StartActivityStream&";
  if (m_resourceArnHasBeenSet) {
    ss << "ResourceArn=" << StringUtils::URLEncode(m_resourceArn.c_str()) << "&";
  }

  if (m_modeHasBeenSet) {
    ss << "Mode=" << StringUtils::URLEncode(ActivityStreamModeMapper::GetNameForActivityStreamMode(m_mode)) << "&";
  }

  if (m_kmsKeyIdHasBeenSet) {
    ss << "KmsKeyId=" << StringUtils::URLEncode(m_kmsKeyId.c_str()) << "&";
  }

  if (m_applyImmediatelyHasBeenSet) {
    ss << "ApplyImmediately=" << std::boolalpha << m_applyImmediately << "&";
  }

  if (m_engineNativeAuditFieldsIncludedHasBeenSet) {
    ss << "EngineNativeAuditFieldsIncluded=" << std::boolalpha << m_engineNativeAuditFieldsIncluded << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void StartActivityStreamRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
