﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/DeleteDatasetRequest.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteDatasetRequest::SerializePayload() const {
  JsonValue payload;

  if (m_datasetArnHasBeenSet) {
    payload.WithString("DatasetArn", m_datasetArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteDatasetRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "RekognitionService.DeleteDataset"));
  return headers;
}
