﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/PersonDetail.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {

PersonDetail::PersonDetail(JsonView jsonValue) { *this = jsonValue; }

PersonDetail& PersonDetail::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Index")) {
    m_index = jsonValue.GetInt64("Index");
    m_indexHasBeenSet = true;
  }
  if (jsonValue.ValueExists("BoundingBox")) {
    m_boundingBox = jsonValue.GetObject("BoundingBox");
    m_boundingBoxHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Face")) {
    m_face = jsonValue.GetObject("Face");
    m_faceHasBeenSet = true;
  }
  return *this;
}

JsonValue PersonDetail::Jsonize() const {
  JsonValue payload;

  if (m_indexHasBeenSet) {
    payload.WithInt64("Index", m_index);
  }

  if (m_boundingBoxHasBeenSet) {
    payload.WithObject("BoundingBox", m_boundingBox.Jsonize());
  }

  if (m_faceHasBeenSet) {
    payload.WithObject("Face", m_face.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
