﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/resiliencehub/model/ListRecommendationTemplatesResult.h>

#include <utility>

using namespace Aws::ResilienceHub::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRecommendationTemplatesResult::ListRecommendationTemplatesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListRecommendationTemplatesResult& ListRecommendationTemplatesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("recommendationTemplates")) {
    Aws::Utils::Array<JsonView> recommendationTemplatesJsonList = jsonValue.GetArray("recommendationTemplates");
    for (unsigned recommendationTemplatesIndex = 0; recommendationTemplatesIndex < recommendationTemplatesJsonList.GetLength();
         ++recommendationTemplatesIndex) {
      m_recommendationTemplates.push_back(recommendationTemplatesJsonList[recommendationTemplatesIndex].AsObject());
    }
    m_recommendationTemplatesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
