﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/rolesanywhere/model/NotificationChannel.h>

using namespace Aws::Utils;

namespace Aws {
namespace RolesAnywhere {
namespace Model {
namespace NotificationChannelMapper {

static const int ALL_HASH = HashingUtils::HashString("ALL");

NotificationChannel GetNotificationChannelForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ALL_HASH) {
    return NotificationChannel::ALL;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<NotificationChannel>(hashCode);
  }

  return NotificationChannel::NOT_SET;
}

Aws::String GetNameForNotificationChannel(NotificationChannel enumValue) {
  switch (enumValue) {
    case NotificationChannel::NOT_SET:
      return {};
    case NotificationChannel::ALL:
      return "ALL";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace NotificationChannelMapper
}  // namespace Model
}  // namespace RolesAnywhere
}  // namespace Aws
