﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/route53/model/AccountLimit.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace Route53 {
namespace Model {

AccountLimit::AccountLimit(const XmlNode& xmlNode) { *this = xmlNode; }

AccountLimit& AccountLimit::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode typeNode = resultNode.FirstChild("Type");
    if (!typeNode.IsNull()) {
      m_type = AccountLimitTypeMapper::GetAccountLimitTypeForName(
          StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(typeNode.GetText()).c_str()));
      m_typeHasBeenSet = true;
    }
    XmlNode valueNode = resultNode.FirstChild("Value");
    if (!valueNode.IsNull()) {
      m_value = StringUtils::ConvertToInt64(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(valueNode.GetText()).c_str()).c_str());
      m_valueHasBeenSet = true;
    }
  }

  return *this;
}

void AccountLimit::AddToNode(XmlNode& parentNode) const {
  Aws::StringStream ss;
  if (m_typeHasBeenSet) {
    XmlNode typeNode = parentNode.CreateChildElement("Type");
    typeNode.SetText(AccountLimitTypeMapper::GetNameForAccountLimitType(m_type));
  }

  if (m_valueHasBeenSet) {
    XmlNode valueNode = parentNode.CreateChildElement("Value");
    ss << m_value;
    valueNode.SetText(ss.str());
    ss.str("");
  }
}

}  // namespace Model
}  // namespace Route53
}  // namespace Aws
