﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/s3control/model/Region.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace S3Control {
namespace Model {

Region::Region(const XmlNode& xmlNode) { *this = xmlNode; }

Region& Region::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode bucketNode = resultNode.FirstChild("Bucket");
    if (!bucketNode.IsNull()) {
      m_bucket = Aws::Utils::Xml::DecodeEscapedXmlText(bucketNode.GetText());
      m_bucketHasBeenSet = true;
    }
    XmlNode bucketAccountIdNode = resultNode.FirstChild("BucketAccountId");
    if (!bucketAccountIdNode.IsNull()) {
      m_bucketAccountId = Aws::Utils::Xml::DecodeEscapedXmlText(bucketAccountIdNode.GetText());
      m_bucketAccountIdHasBeenSet = true;
    }
  }

  return *this;
}

void Region::AddToNode(XmlNode& parentNode) const {
  Aws::StringStream ss;
  if (m_bucketHasBeenSet) {
    XmlNode bucketNode = parentNode.CreateChildElement("Bucket");
    bucketNode.SetText(m_bucket);
  }

  if (m_bucketAccountIdHasBeenSet) {
    XmlNode bucketAccountIdNode = parentNode.CreateChildElement("BucketAccountId");
    bucketAccountIdNode.SetText(m_bucketAccountId);
  }
}

}  // namespace Model
}  // namespace S3Control
}  // namespace Aws
