﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/client/AWSError.h>
#include <aws/s3tables/S3TablesErrorMarshaller.h>
#include <aws/s3tables/S3TablesErrors.h>

using namespace Aws::Client;
using namespace Aws::S3Tables;

AWSError<CoreErrors> S3TablesErrorMarshaller::FindErrorByName(const char* errorName) const {
  AWSError<CoreErrors> error = S3TablesErrorMapper::GetErrorForName(errorName);
  if (error.GetErrorType() != CoreErrors::UNKNOWN) {
    return error;
  }

  return AWSErrorMarshaller::FindErrorByName(errorName);
}