﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/s3tables/model/ListTablesResult.h>

#include <utility>

using namespace Aws::S3Tables::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListTablesResult::ListTablesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListTablesResult& ListTablesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("tables")) {
    Aws::Utils::Array<JsonView> tablesJsonList = jsonValue.GetArray("tables");
    for (unsigned tablesIndex = 0; tablesIndex < tablesJsonList.GetLength(); ++tablesIndex) {
      m_tables.push_back(tablesJsonList[tablesIndex].AsObject());
    }
    m_tablesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("continuationToken")) {
    m_continuationToken = jsonValue.GetString("continuationToken");
    m_continuationTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
