﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/states/model/CreateStateMachineRequest.h>

#include <utility>

using namespace Aws::SFN::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateStateMachineRequest::SerializePayload() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_definitionHasBeenSet) {
    payload.WithString("definition", m_definition);
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("roleArn", m_roleArn);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("type", StateMachineTypeMapper::GetNameForStateMachineType(m_type));
  }

  if (m_loggingConfigurationHasBeenSet) {
    payload.WithObject("loggingConfiguration", m_loggingConfiguration.Jsonize());
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("tags", std::move(tagsJsonList));
  }

  if (m_tracingConfigurationHasBeenSet) {
    payload.WithObject("tracingConfiguration", m_tracingConfiguration.Jsonize());
  }

  if (m_publishHasBeenSet) {
    payload.WithBool("publish", m_publish);
  }

  if (m_versionDescriptionHasBeenSet) {
    payload.WithString("versionDescription", m_versionDescription);
  }

  if (m_encryptionConfigurationHasBeenSet) {
    payload.WithObject("encryptionConfiguration", m_encryptionConfiguration.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateStateMachineRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSStepFunctions.CreateStateMachine"));
  return headers;
}
