﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/states/model/StartSyncExecutionResult.h>

#include <utility>

using namespace Aws::SFN::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

StartSyncExecutionResult::StartSyncExecutionResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

StartSyncExecutionResult& StartSyncExecutionResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("executionArn")) {
    m_executionArn = jsonValue.GetString("executionArn");
    m_executionArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("stateMachineArn")) {
    m_stateMachineArn = jsonValue.GetString("stateMachineArn");
    m_stateMachineArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("startDate")) {
    m_startDate = jsonValue.GetDouble("startDate");
    m_startDateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("stopDate")) {
    m_stopDate = jsonValue.GetDouble("stopDate");
    m_stopDateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("status")) {
    m_status = SyncExecutionStatusMapper::GetSyncExecutionStatusForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("error")) {
    m_error = jsonValue.GetString("error");
    m_errorHasBeenSet = true;
  }
  if (jsonValue.ValueExists("cause")) {
    m_cause = jsonValue.GetString("cause");
    m_causeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("input")) {
    m_input = jsonValue.GetString("input");
    m_inputHasBeenSet = true;
  }
  if (jsonValue.ValueExists("inputDetails")) {
    m_inputDetails = jsonValue.GetObject("inputDetails");
    m_inputDetailsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("output")) {
    m_output = jsonValue.GetString("output");
    m_outputHasBeenSet = true;
  }
  if (jsonValue.ValueExists("outputDetails")) {
    m_outputDetails = jsonValue.GetObject("outputDetails");
    m_outputDetailsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("traceHeader")) {
    m_traceHeader = jsonValue.GetString("traceHeader");
    m_traceHeaderHasBeenSet = true;
  }
  if (jsonValue.ValueExists("billingDetails")) {
    m_billingDetails = jsonValue.GetObject("billingDetails");
    m_billingDetailsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
