﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/storagegateway/model/CreateCachediSCSIVolumeRequest.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateCachediSCSIVolumeRequest::SerializePayload() const {
  JsonValue payload;

  if (m_gatewayARNHasBeenSet) {
    payload.WithString("GatewayARN", m_gatewayARN);
  }

  if (m_volumeSizeInBytesHasBeenSet) {
    payload.WithInt64("VolumeSizeInBytes", m_volumeSizeInBytes);
  }

  if (m_snapshotIdHasBeenSet) {
    payload.WithString("SnapshotId", m_snapshotId);
  }

  if (m_targetNameHasBeenSet) {
    payload.WithString("TargetName", m_targetName);
  }

  if (m_sourceVolumeARNHasBeenSet) {
    payload.WithString("SourceVolumeARN", m_sourceVolumeARN);
  }

  if (m_networkInterfaceIdHasBeenSet) {
    payload.WithString("NetworkInterfaceId", m_networkInterfaceId);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_kMSEncryptedHasBeenSet) {
    payload.WithBool("KMSEncrypted", m_kMSEncrypted);
  }

  if (m_kMSKeyHasBeenSet) {
    payload.WithString("KMSKey", m_kMSKey);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateCachediSCSIVolumeRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StorageGateway_20130630.CreateCachediSCSIVolume"));
  return headers;
}
