﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/storagegateway/model/CreateNFSFileShareRequest.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateNFSFileShareRequest::SerializePayload() const {
  JsonValue payload;

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_nFSFileShareDefaultsHasBeenSet) {
    payload.WithObject("NFSFileShareDefaults", m_nFSFileShareDefaults.Jsonize());
  }

  if (m_gatewayARNHasBeenSet) {
    payload.WithString("GatewayARN", m_gatewayARN);
  }

  if (m_encryptionTypeHasBeenSet) {
    payload.WithString("EncryptionType", EncryptionTypeMapper::GetNameForEncryptionType(m_encryptionType));
  }

  if (m_kMSKeyHasBeenSet) {
    payload.WithString("KMSKey", m_kMSKey);
  }

  if (m_roleHasBeenSet) {
    payload.WithString("Role", m_role);
  }

  if (m_locationARNHasBeenSet) {
    payload.WithString("LocationARN", m_locationARN);
  }

  if (m_defaultStorageClassHasBeenSet) {
    payload.WithString("DefaultStorageClass", m_defaultStorageClass);
  }

  if (m_objectACLHasBeenSet) {
    payload.WithString("ObjectACL", ObjectACLMapper::GetNameForObjectACL(m_objectACL));
  }

  if (m_clientListHasBeenSet) {
    Aws::Utils::Array<JsonValue> clientListJsonList(m_clientList.size());
    for (unsigned clientListIndex = 0; clientListIndex < clientListJsonList.GetLength(); ++clientListIndex) {
      clientListJsonList[clientListIndex].AsString(m_clientList[clientListIndex]);
    }
    payload.WithArray("ClientList", std::move(clientListJsonList));
  }

  if (m_squashHasBeenSet) {
    payload.WithString("Squash", m_squash);
  }

  if (m_readOnlyHasBeenSet) {
    payload.WithBool("ReadOnly", m_readOnly);
  }

  if (m_guessMIMETypeEnabledHasBeenSet) {
    payload.WithBool("GuessMIMETypeEnabled", m_guessMIMETypeEnabled);
  }

  if (m_requesterPaysHasBeenSet) {
    payload.WithBool("RequesterPays", m_requesterPays);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  if (m_fileShareNameHasBeenSet) {
    payload.WithString("FileShareName", m_fileShareName);
  }

  if (m_cacheAttributesHasBeenSet) {
    payload.WithObject("CacheAttributes", m_cacheAttributes.Jsonize());
  }

  if (m_notificationPolicyHasBeenSet) {
    payload.WithString("NotificationPolicy", m_notificationPolicy);
  }

  if (m_vPCEndpointDNSNameHasBeenSet) {
    payload.WithString("VPCEndpointDNSName", m_vPCEndpointDNSName);
  }

  if (m_bucketRegionHasBeenSet) {
    payload.WithString("BucketRegion", m_bucketRegion);
  }

  if (m_auditDestinationARNHasBeenSet) {
    payload.WithString("AuditDestinationARN", m_auditDestinationARN);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateNFSFileShareRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StorageGateway_20130630.CreateNFSFileShare"));
  return headers;
}
