﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/storagegateway/model/CreateTapesRequest.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateTapesRequest::SerializePayload() const {
  JsonValue payload;

  if (m_gatewayARNHasBeenSet) {
    payload.WithString("GatewayARN", m_gatewayARN);
  }

  if (m_tapeSizeInBytesHasBeenSet) {
    payload.WithInt64("TapeSizeInBytes", m_tapeSizeInBytes);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_numTapesToCreateHasBeenSet) {
    payload.WithInteger("NumTapesToCreate", m_numTapesToCreate);
  }

  if (m_tapeBarcodePrefixHasBeenSet) {
    payload.WithString("TapeBarcodePrefix", m_tapeBarcodePrefix);
  }

  if (m_kMSEncryptedHasBeenSet) {
    payload.WithBool("KMSEncrypted", m_kMSEncrypted);
  }

  if (m_kMSKeyHasBeenSet) {
    payload.WithString("KMSKey", m_kMSKey);
  }

  if (m_poolIdHasBeenSet) {
    payload.WithString("PoolId", m_poolId);
  }

  if (m_wormHasBeenSet) {
    payload.WithBool("Worm", m_worm);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateTapesRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StorageGateway_20130630.CreateTapes"));
  return headers;
}
