﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/storagegateway/model/StartCacheReportRequest.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartCacheReportRequest::SerializePayload() const {
  JsonValue payload;

  if (m_fileShareARNHasBeenSet) {
    payload.WithString("FileShareARN", m_fileShareARN);
  }

  if (m_roleHasBeenSet) {
    payload.WithString("Role", m_role);
  }

  if (m_locationARNHasBeenSet) {
    payload.WithString("LocationARN", m_locationARN);
  }

  if (m_bucketRegionHasBeenSet) {
    payload.WithString("BucketRegion", m_bucketRegion);
  }

  if (m_vPCEndpointDNSNameHasBeenSet) {
    payload.WithString("VPCEndpointDNSName", m_vPCEndpointDNSName);
  }

  if (m_inclusionFiltersHasBeenSet) {
    Aws::Utils::Array<JsonValue> inclusionFiltersJsonList(m_inclusionFilters.size());
    for (unsigned inclusionFiltersIndex = 0; inclusionFiltersIndex < inclusionFiltersJsonList.GetLength(); ++inclusionFiltersIndex) {
      inclusionFiltersJsonList[inclusionFiltersIndex].AsObject(m_inclusionFilters[inclusionFiltersIndex].Jsonize());
    }
    payload.WithArray("InclusionFilters", std::move(inclusionFiltersJsonList));
  }

  if (m_exclusionFiltersHasBeenSet) {
    Aws::Utils::Array<JsonValue> exclusionFiltersJsonList(m_exclusionFilters.size());
    for (unsigned exclusionFiltersIndex = 0; exclusionFiltersIndex < exclusionFiltersJsonList.GetLength(); ++exclusionFiltersIndex) {
      exclusionFiltersJsonList[exclusionFiltersIndex].AsObject(m_exclusionFilters[exclusionFiltersIndex].Jsonize());
    }
    payload.WithArray("ExclusionFilters", std::move(exclusionFiltersJsonList));
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StartCacheReportRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StorageGateway_20130630.StartCacheReport"));
  return headers;
}
