﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/supplychain/model/ListDataIntegrationFlowsResult.h>

#include <utility>

using namespace Aws::SupplyChain::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDataIntegrationFlowsResult::ListDataIntegrationFlowsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListDataIntegrationFlowsResult& ListDataIntegrationFlowsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("flows")) {
    Aws::Utils::Array<JsonView> flowsJsonList = jsonValue.GetArray("flows");
    for (unsigned flowsIndex = 0; flowsIndex < flowsJsonList.GetLength(); ++flowsIndex) {
      m_flows.push_back(flowsJsonList[flowsIndex].AsObject());
    }
    m_flowsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
