﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/swf/model/LambdaFunctionCompletedEventAttributes.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace SWF {
namespace Model {

LambdaFunctionCompletedEventAttributes::LambdaFunctionCompletedEventAttributes(JsonView jsonValue) { *this = jsonValue; }

LambdaFunctionCompletedEventAttributes& LambdaFunctionCompletedEventAttributes::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("scheduledEventId")) {
    m_scheduledEventId = jsonValue.GetInt64("scheduledEventId");
    m_scheduledEventIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("startedEventId")) {
    m_startedEventId = jsonValue.GetInt64("startedEventId");
    m_startedEventIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("result")) {
    m_result = jsonValue.GetString("result");
    m_resultHasBeenSet = true;
  }
  return *this;
}

JsonValue LambdaFunctionCompletedEventAttributes::Jsonize() const {
  JsonValue payload;

  if (m_scheduledEventIdHasBeenSet) {
    payload.WithInt64("scheduledEventId", m_scheduledEventId);
  }

  if (m_startedEventIdHasBeenSet) {
    payload.WithInt64("startedEventId", m_startedEventId);
  }

  if (m_resultHasBeenSet) {
    payload.WithString("result", m_result);
  }

  return payload;
}

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
