﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/timestream-query/model/ExecuteScheduledQueryRequest.h>

#include <utility>

using namespace Aws::TimestreamQuery::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ExecuteScheduledQueryRequest::SerializePayload() const {
  JsonValue payload;

  if (m_scheduledQueryArnHasBeenSet) {
    payload.WithString("ScheduledQueryArn", m_scheduledQueryArn);
  }

  if (m_invocationTimeHasBeenSet) {
    payload.WithDouble("InvocationTime", m_invocationTime.SecondsWithMSPrecision());
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_queryInsightsHasBeenSet) {
    payload.WithObject("QueryInsights", m_queryInsights.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ExecuteScheduledQueryRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Timestream_20181101.ExecuteScheduledQuery"));
  return headers;
}
