﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/timestream-query/model/QueryRequest.h>

#include <utility>

using namespace Aws::TimestreamQuery::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String QueryRequest::SerializePayload() const {
  JsonValue payload;

  if (m_queryStringHasBeenSet) {
    payload.WithString("QueryString", m_queryString);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_maxRowsHasBeenSet) {
    payload.WithInteger("MaxRows", m_maxRows);
  }

  if (m_queryInsightsHasBeenSet) {
    payload.WithObject("QueryInsights", m_queryInsights.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection QueryRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Timestream_20181101.Query"));
  return headers;
}
