﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/transcribestreaming/model/MedicalAlternative.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace TranscribeStreamingService {
namespace Model {

MedicalAlternative::MedicalAlternative(JsonView jsonValue) { *this = jsonValue; }

MedicalAlternative& MedicalAlternative::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Transcript")) {
    m_transcript = jsonValue.GetString("Transcript");
    m_transcriptHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Items")) {
    Aws::Utils::Array<JsonView> itemsJsonList = jsonValue.GetArray("Items");
    for (unsigned itemsIndex = 0; itemsIndex < itemsJsonList.GetLength(); ++itemsIndex) {
      m_items.push_back(itemsJsonList[itemsIndex].AsObject());
    }
    m_itemsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Entities")) {
    Aws::Utils::Array<JsonView> entitiesJsonList = jsonValue.GetArray("Entities");
    for (unsigned entitiesIndex = 0; entitiesIndex < entitiesJsonList.GetLength(); ++entitiesIndex) {
      m_entities.push_back(entitiesJsonList[entitiesIndex].AsObject());
    }
    m_entitiesHasBeenSet = true;
  }
  return *this;
}

JsonValue MedicalAlternative::Jsonize() const {
  JsonValue payload;

  if (m_transcriptHasBeenSet) {
    payload.WithString("Transcript", m_transcript);
  }

  if (m_itemsHasBeenSet) {
    Aws::Utils::Array<JsonValue> itemsJsonList(m_items.size());
    for (unsigned itemsIndex = 0; itemsIndex < itemsJsonList.GetLength(); ++itemsIndex) {
      itemsJsonList[itemsIndex].AsObject(m_items[itemsIndex].Jsonize());
    }
    payload.WithArray("Items", std::move(itemsJsonList));
  }

  if (m_entitiesHasBeenSet) {
    Aws::Utils::Array<JsonValue> entitiesJsonList(m_entities.size());
    for (unsigned entitiesIndex = 0; entitiesIndex < entitiesJsonList.GetLength(); ++entitiesIndex) {
      entitiesJsonList[entitiesIndex].AsObject(m_entities[entitiesIndex].Jsonize());
    }
    payload.WithArray("Entities", std::move(entitiesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace TranscribeStreamingService
}  // namespace Aws
