﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/transcribestreaming/model/MedicalItem.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace TranscribeStreamingService {
namespace Model {

MedicalItem::MedicalItem(JsonView jsonValue) { *this = jsonValue; }

MedicalItem& MedicalItem::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("StartTime")) {
    m_startTime = jsonValue.GetDouble("StartTime");
    m_startTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EndTime")) {
    m_endTime = jsonValue.GetDouble("EndTime");
    m_endTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Type")) {
    m_type = ItemTypeMapper::GetItemTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Content")) {
    m_content = jsonValue.GetString("Content");
    m_contentHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Confidence")) {
    m_confidence = jsonValue.GetDouble("Confidence");
    m_confidenceHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Speaker")) {
    m_speaker = jsonValue.GetString("Speaker");
    m_speakerHasBeenSet = true;
  }
  return *this;
}

JsonValue MedicalItem::Jsonize() const {
  JsonValue payload;

  if (m_startTimeHasBeenSet) {
    payload.WithDouble("StartTime", m_startTime);
  }

  if (m_endTimeHasBeenSet) {
    payload.WithDouble("EndTime", m_endTime);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("Type", ItemTypeMapper::GetNameForItemType(m_type));
  }

  if (m_contentHasBeenSet) {
    payload.WithString("Content", m_content);
  }

  if (m_confidenceHasBeenSet) {
    payload.WithDouble("Confidence", m_confidence);
  }

  if (m_speakerHasBeenSet) {
    payload.WithString("Speaker", m_speaker);
  }

  return payload;
}

}  // namespace Model
}  // namespace TranscribeStreamingService
}  // namespace Aws
