﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/wellarchitected/model/CreateReviewTemplateRequest.h>

#include <utility>

using namespace Aws::WellArchitected::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateReviewTemplateRequest::SerializePayload() const {
  JsonValue payload;

  if (m_templateNameHasBeenSet) {
    payload.WithString("TemplateName", m_templateName);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  if (m_lensesHasBeenSet) {
    Aws::Utils::Array<JsonValue> lensesJsonList(m_lenses.size());
    for (unsigned lensesIndex = 0; lensesIndex < lensesJsonList.GetLength(); ++lensesIndex) {
      lensesJsonList[lensesIndex].AsString(m_lenses[lensesIndex]);
    }
    payload.WithArray("Lenses", std::move(lensesJsonList));
  }

  if (m_notesHasBeenSet) {
    payload.WithString("Notes", m_notes);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("Tags", std::move(tagsJsonMap));
  }

  if (m_clientRequestTokenHasBeenSet) {
    payload.WithString("ClientRequestToken", m_clientRequestToken);
  }

  return payload.View().WriteReadable();
}
