﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/wellarchitected/model/ListMilestonesResult.h>

#include <utility>

using namespace Aws::WellArchitected::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListMilestonesResult::ListMilestonesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListMilestonesResult& ListMilestonesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("WorkloadId")) {
    m_workloadId = jsonValue.GetString("WorkloadId");
    m_workloadIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("MilestoneSummaries")) {
    Aws::Utils::Array<JsonView> milestoneSummariesJsonList = jsonValue.GetArray("MilestoneSummaries");
    for (unsigned milestoneSummariesIndex = 0; milestoneSummariesIndex < milestoneSummariesJsonList.GetLength();
         ++milestoneSummariesIndex) {
      m_milestoneSummaries.push_back(milestoneSummariesJsonList[milestoneSummariesIndex].AsObject());
    }
    m_milestoneSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
