﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/wellarchitected/model/UpdateShareInvitationRequest.h>

#include <utility>

using namespace Aws::WellArchitected::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateShareInvitationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_shareInvitationActionHasBeenSet) {
    payload.WithString("ShareInvitationAction", ShareInvitationActionMapper::GetNameForShareInvitationAction(m_shareInvitationAction));
  }

  return payload.View().WriteReadable();
}
