﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workmail/model/Domain.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace WorkMail {
namespace Model {

Domain::Domain(JsonView jsonValue) { *this = jsonValue; }

Domain& Domain::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("DomainName")) {
    m_domainName = jsonValue.GetString("DomainName");
    m_domainNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("HostedZoneId")) {
    m_hostedZoneId = jsonValue.GetString("HostedZoneId");
    m_hostedZoneIdHasBeenSet = true;
  }
  return *this;
}

JsonValue Domain::Jsonize() const {
  JsonValue payload;

  if (m_domainNameHasBeenSet) {
    payload.WithString("DomainName", m_domainName);
  }

  if (m_hostedZoneIdHasBeenSet) {
    payload.WithString("HostedZoneId", m_hostedZoneId);
  }

  return payload;
}

}  // namespace Model
}  // namespace WorkMail
}  // namespace Aws
