﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/workspaces/model/AuthenticationType.h>

using namespace Aws::Utils;

namespace Aws {
namespace WorkSpaces {
namespace Model {
namespace AuthenticationTypeMapper {

static const int SAML_HASH = HashingUtils::HashString("SAML");

AuthenticationType GetAuthenticationTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == SAML_HASH) {
    return AuthenticationType::SAML;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<AuthenticationType>(hashCode);
  }

  return AuthenticationType::NOT_SET;
}

Aws::String GetNameForAuthenticationType(AuthenticationType enumValue) {
  switch (enumValue) {
    case AuthenticationType::NOT_SET:
      return {};
    case AuthenticationType::SAML:
      return "SAML";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace AuthenticationTypeMapper
}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
