﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workspaces/model/NetworkAccessConfiguration.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace WorkSpaces {
namespace Model {

NetworkAccessConfiguration::NetworkAccessConfiguration(JsonView jsonValue) { *this = jsonValue; }

NetworkAccessConfiguration& NetworkAccessConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("EniPrivateIpAddress")) {
    m_eniPrivateIpAddress = jsonValue.GetString("EniPrivateIpAddress");
    m_eniPrivateIpAddressHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EniId")) {
    m_eniId = jsonValue.GetString("EniId");
    m_eniIdHasBeenSet = true;
  }
  return *this;
}

JsonValue NetworkAccessConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_eniPrivateIpAddressHasBeenSet) {
    payload.WithString("EniPrivateIpAddress", m_eniPrivateIpAddress);
  }

  if (m_eniIdHasBeenSet) {
    payload.WithString("EniId", m_eniId);
  }

  return payload;
}

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
