﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/workspaces/model/UpdateWorkspaceImagePermissionRequest.h>

#include <utility>

using namespace Aws::WorkSpaces::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateWorkspaceImagePermissionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_imageIdHasBeenSet) {
    payload.WithString("ImageId", m_imageId);
  }

  if (m_allowCopyImageHasBeenSet) {
    payload.WithBool("AllowCopyImage", m_allowCopyImage);
  }

  if (m_sharedAccountIdHasBeenSet) {
    payload.WithString("SharedAccountId", m_sharedAccountId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateWorkspaceImagePermissionRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "WorkspacesService.UpdateWorkspaceImagePermission"));
  return headers;
}
