/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

/**
 * Please note that this file is autogenerated.
 * The backwards compatibility of the default values provided by new client configuration defaults is not guaranteed; 
 *   the values might change over time.
 */

#include <aws/common/platform.h>  // for AWS_OS_IOS macro
#include <aws/core/config/defaults/ClientConfigurationDefaults.h>
#include <aws/core/config/AWSProfileConfigLoader.h>
#include <aws/core/client/ClientConfiguration.h>
#include <aws/core/internal/AWSHttpResourceClient.h>
#include <aws/core/platform/Environment.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>

namespace Aws
{
    namespace Config
    {
        namespace Defaults
        {
            static const char* CLIENT_CONFIG_DEFAULTS_TAG = "ClientConfigurationDefaults";

            void SetSmartDefaultsConfigurationParameters(Aws::Client::ClientConfiguration& clientConfig,
                                                         const Aws::String& defaultMode,
                                                         bool hasEc2MetadataRegion,
                                                         const Aws::String& ec2MetadataRegion)
            {
                const Aws::String caseInsensitiveMode = ResolveDefaultModeName(clientConfig,
                                                                               defaultMode,
                                                                               Aws::Config::GetCachedConfigValue("defaults_mode"),
                                                                               hasEc2MetadataRegion,
                                                                               ec2MetadataRegion);

                if(caseInsensitiveMode == "legacy")
                {
                    return SetLegacyClientConfiguration(clientConfig);
                }

                if(caseInsensitiveMode == "standard")
                {
                    return SetStandardClientConfiguration(clientConfig);
                }

                if(caseInsensitiveMode == "in-region")
                {
                    return SetInRegionClientConfiguration(clientConfig);
                }

                if(caseInsensitiveMode == "cross-region")
                {
                    return SetCrossRegionClientConfiguration(clientConfig);
                }

                if(caseInsensitiveMode == "mobile")
                {
                    return SetMobileClientConfiguration(clientConfig);
                }
                return SetLegacyClientConfiguration(clientConfig);
            }

            bool isMobile()
            {
#if defined(AWS_OS_IOS) || defined (__ANDROID__)
                return true;
#else
                return false;
#endif
            }

            const char* ResolveAutoClientConfiguration(const Aws::Client::ClientConfiguration& clientConfig,
                                                       const Aws::String& ec2MetadataRegion)
            {
                // Check if we're on mobile, CPP SDK is statically built, so we can check how we were built
                if(isMobile())
                {
                    return "mobile";
                }
                // We're not on mobile (best we can tell). See if we can determine whether we're an in-region or
                // cross-region client.
                Aws::String current_region;
                Aws::String env_region = Aws::Environment::GetEnv("AWS_DEFAULT_REGION");
                if(!Aws::Environment::GetEnv("AWS_EXECUTION_ENV").empty())
                {
                    // We're running in an AWS service environment, so we can trust the region environment variables
                    // to be the current region, if they're set
                    current_region = Aws::Environment::GetEnv("AWS_REGION");
                    if(current_region.empty())
                    {
                        current_region = Aws::Environment::GetEnv("AWS_DEFAULT_REGION");
                    }
                }
                if(current_region.empty())
                {
                    current_region = ec2MetadataRegion;
                }
                if(!current_region.empty() && !clientConfig.region.empty())
                {
                    if(current_region == clientConfig.region)
                    {
                        return "in-region";
                    }
                    else
                    {
                        return "cross-region";
                    }
                }
                // We don't seem to be mobile, and we couldn't determine whether we're running within an AWS region.
                // Fall back to standard.
                return "standard";
            }

            void SetLegacyClientConfiguration(Aws::Client::ClientConfiguration& clientConfig)
            {
                clientConfig.retryStrategy = Aws::Client::InitRetryStrategy("default");
            }

            void SetStandardClientConfiguration(Aws::Client::ClientConfiguration& clientConfig)
            {
                clientConfig.connectTimeoutMs = 3100;
                clientConfig.retryStrategy = Aws::Client::InitRetryStrategy("standard");
            }

            void SetInRegionClientConfiguration(Aws::Client::ClientConfiguration& clientConfig)
            {
                clientConfig.connectTimeoutMs = 1100;
                clientConfig.retryStrategy = Aws::Client::InitRetryStrategy("standard");
            }

            void SetCrossRegionClientConfiguration(Aws::Client::ClientConfiguration& clientConfig)
            {
                clientConfig.connectTimeoutMs = 3100;
                clientConfig.retryStrategy = Aws::Client::InitRetryStrategy("standard");
            }

            void SetMobileClientConfiguration(Aws::Client::ClientConfiguration& clientConfig)
            {
                clientConfig.connectTimeoutMs = 30000;
                clientConfig.retryStrategy = Aws::Client::InitRetryStrategy("standard");
            }

            Aws::String ResolveDefaultModeName(const Aws::Client::ClientConfiguration& clientConfig,
                                               Aws::String requestedDefaultMode,
                                               const Aws::String& configFileDefaultMode,
                                               bool hasEc2MetadataRegion,
                                               Aws::String ec2MetadataRegion)
            {
                if (requestedDefaultMode.empty())
                {
                    requestedDefaultMode = Aws::Environment::GetEnv("AWS_DEFAULTS_MODE");
                }
                if (requestedDefaultMode.empty())
                {
                    requestedDefaultMode = configFileDefaultMode;
                }
                if (Aws::Utils::StringUtils::ToLower(requestedDefaultMode.c_str()) == "auto")
                {
                    if (!hasEc2MetadataRegion && 
                        Aws::Utils::StringUtils::ToLower(Aws::Environment::GetEnv("AWS_EC2_METADATA_DISABLED").c_str()) != "true") 
                    {
                        auto client = Aws::Internal::GetEC2MetadataClient();
                        if (client)
                        {
                            ec2MetadataRegion = client->GetCurrentRegion();
                        }
                    }
                    requestedDefaultMode = ResolveAutoClientConfiguration(clientConfig, ec2MetadataRegion);
                    return requestedDefaultMode;
                }
                if (requestedDefaultMode.empty())
                {
                    requestedDefaultMode = "legacy";
                    return requestedDefaultMode;
                }

                requestedDefaultMode = Aws::Utils::StringUtils::ToLower(requestedDefaultMode.c_str());
                if (requestedDefaultMode != "legacy" &&
                    requestedDefaultMode != "standard" &&
                    requestedDefaultMode != "in-region" &&
                    requestedDefaultMode != "cross-region" &&
                    requestedDefaultMode != "mobile")
                {
                    AWS_LOGSTREAM_WARN(CLIENT_CONFIG_DEFAULTS_TAG, "User specified client configuration: [" 
                                           << requestedDefaultMode 
                                           << "] is not found, will use the SDK default legacy one.");
                    requestedDefaultMode = "legacy";
                }
                return requestedDefaultMode;
            }
        } //namespace Defaults
    } //namespace Config
} //namespace Aws
