/* Copyright (c) 2020, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

package testconfig

import (
	"encoding/json"
	"os"
)

type Test struct {
	Cmd           	[]string `json:"cmd"`
	Env           	[]string `json:"env"`
	SkipSDE       	bool     `json:"skip_sde"`
	SkipValgrind 	bool 	 `json:"skip_valgrind"`
	ValgrindSupp  	[]string `json:"valgrind_supp"`
	TargetArch  	string 	 `json:"target_arch"`
	Shard           bool     `json:"shard"`
}

func ParseTestConfig(filename string) ([]Test, error) {
	in, err := os.Open(filename)
	if err != nil {
		return nil, err
	}
	defer in.Close()

	decoder := json.NewDecoder(in)
	var result []Test
	if err := decoder.Decode(&result); err != nil {
		return nil, err
	}
	return result, nil
}
