﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/devops-guru/model/UpdateResourceCollectionRequest.h>

#include <utility>

using namespace Aws::DevOpsGuru::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateResourceCollectionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_actionHasBeenSet) {
    payload.WithString("Action", UpdateResourceCollectionActionMapper::GetNameForUpdateResourceCollectionAction(m_action));
  }

  if (m_resourceCollectionHasBeenSet) {
    payload.WithObject("ResourceCollection", m_resourceCollection.Jsonize());
  }

  return payload.View().WriteReadable();
}
