﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/directory-service-data/model/CreateUserRequest.h>

#include <utility>

using namespace Aws::DirectoryServiceData::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String CreateUserRequest::SerializePayload() const {
  JsonValue payload;

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_emailAddressHasBeenSet) {
    payload.WithString("EmailAddress", m_emailAddress);
  }

  if (m_givenNameHasBeenSet) {
    payload.WithString("GivenName", m_givenName);
  }

  if (m_otherAttributesHasBeenSet) {
    JsonValue otherAttributesJsonMap;
    for (auto& otherAttributesItem : m_otherAttributes) {
      otherAttributesJsonMap.WithObject(otherAttributesItem.first, otherAttributesItem.second.Jsonize());
    }
    payload.WithObject("OtherAttributes", std::move(otherAttributesJsonMap));
  }

  if (m_sAMAccountNameHasBeenSet) {
    payload.WithString("SAMAccountName", m_sAMAccountName);
  }

  if (m_surnameHasBeenSet) {
    payload.WithString("Surname", m_surname);
  }

  return payload.View().WriteReadable();
}

void CreateUserRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_directoryIdHasBeenSet) {
    ss << m_directoryId;
    uri.AddQueryStringParameter("DirectoryId", ss.str());
    ss.str("");
  }
}
