﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/directory-service-data/model/RemoveGroupMemberRequest.h>

#include <utility>

using namespace Aws::DirectoryServiceData::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String RemoveGroupMemberRequest::SerializePayload() const {
  JsonValue payload;

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_groupNameHasBeenSet) {
    payload.WithString("GroupName", m_groupName);
  }

  if (m_memberNameHasBeenSet) {
    payload.WithString("MemberName", m_memberName);
  }

  if (m_memberRealmHasBeenSet) {
    payload.WithString("MemberRealm", m_memberRealm);
  }

  return payload.View().WriteReadable();
}

void RemoveGroupMemberRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_directoryIdHasBeenSet) {
    ss << m_directoryId;
    uri.AddQueryStringParameter("DirectoryId", ss.str());
    ss.str("");
  }
}
