﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/ecr/model/UpdatePullThroughCacheRuleRequest.h>

#include <utility>

using namespace Aws::ECR::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdatePullThroughCacheRuleRequest::SerializePayload() const {
  JsonValue payload;

  if (m_registryIdHasBeenSet) {
    payload.WithString("registryId", m_registryId);
  }

  if (m_ecrRepositoryPrefixHasBeenSet) {
    payload.WithString("ecrRepositoryPrefix", m_ecrRepositoryPrefix);
  }

  if (m_credentialArnHasBeenSet) {
    payload.WithString("credentialArn", m_credentialArn);
  }

  if (m_customRoleArnHasBeenSet) {
    payload.WithString("customRoleArn", m_customRoleArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdatePullThroughCacheRuleRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.UpdatePullThroughCacheRule"));
  return headers;
}
