﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/eks/model/CreatePodIdentityAssociationRequest.h>

#include <utility>

using namespace Aws::EKS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreatePodIdentityAssociationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_namespaceHasBeenSet) {
    payload.WithString("namespace", m_namespace);
  }

  if (m_serviceAccountHasBeenSet) {
    payload.WithString("serviceAccount", m_serviceAccount);
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("roleArn", m_roleArn);
  }

  if (m_clientRequestTokenHasBeenSet) {
    payload.WithString("clientRequestToken", m_clientRequestToken);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  if (m_disableSessionTagsHasBeenSet) {
    payload.WithBool("disableSessionTags", m_disableSessionTags);
  }

  if (m_targetRoleArnHasBeenSet) {
    payload.WithString("targetRoleArn", m_targetRoleArn);
  }

  return payload.View().WriteReadable();
}
