﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/eks/model/License.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace EKS {
namespace Model {

License::License(JsonView jsonValue) { *this = jsonValue; }

License& License::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("id")) {
    m_id = jsonValue.GetString("id");
    m_idHasBeenSet = true;
  }
  if (jsonValue.ValueExists("token")) {
    m_token = jsonValue.GetString("token");
    m_tokenHasBeenSet = true;
  }
  return *this;
}

JsonValue License::Jsonize() const {
  JsonValue payload;

  if (m_idHasBeenSet) {
    payload.WithString("id", m_id);
  }

  if (m_tokenHasBeenSet) {
    payload.WithString("token", m_token);
  }

  return payload;
}

}  // namespace Model
}  // namespace EKS
}  // namespace Aws
