﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/eks/model/ListAccessEntriesResult.h>

#include <utility>

using namespace Aws::EKS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAccessEntriesResult::ListAccessEntriesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAccessEntriesResult& ListAccessEntriesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("accessEntries")) {
    Aws::Utils::Array<JsonView> accessEntriesJsonList = jsonValue.GetArray("accessEntries");
    for (unsigned accessEntriesIndex = 0; accessEntriesIndex < accessEntriesJsonList.GetLength(); ++accessEntriesIndex) {
      m_accessEntries.push_back(accessEntriesJsonList[accessEntriesIndex].AsString());
    }
    m_accessEntriesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
