﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/eks/model/ListIdentityProviderConfigsResult.h>

#include <utility>

using namespace Aws::EKS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListIdentityProviderConfigsResult::ListIdentityProviderConfigsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListIdentityProviderConfigsResult& ListIdentityProviderConfigsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("identityProviderConfigs")) {
    Aws::Utils::Array<JsonView> identityProviderConfigsJsonList = jsonValue.GetArray("identityProviderConfigs");
    for (unsigned identityProviderConfigsIndex = 0; identityProviderConfigsIndex < identityProviderConfigsJsonList.GetLength();
         ++identityProviderConfigsIndex) {
      m_identityProviderConfigs.push_back(identityProviderConfigsJsonList[identityProviderConfigsIndex].AsObject());
    }
    m_identityProviderConfigsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
