﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/eks/model/ListPodIdentityAssociationsRequest.h>

#include <utility>

using namespace Aws::EKS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListPodIdentityAssociationsRequest::SerializePayload() const { return {}; }

void ListPodIdentityAssociationsRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_namespaceHasBeenSet) {
    ss << m_namespace;
    uri.AddQueryStringParameter("namespace", ss.str());
    ss.str("");
  }

  if (m_serviceAccountHasBeenSet) {
    ss << m_serviceAccount;
    uri.AddQueryStringParameter("serviceAccount", ss.str());
    ss.str("");
  }

  if (m_maxResultsHasBeenSet) {
    ss << m_maxResults;
    uri.AddQueryStringParameter("maxResults", ss.str());
    ss.str("");
  }

  if (m_nextTokenHasBeenSet) {
    ss << m_nextToken;
    uri.AddQueryStringParameter("nextToken", ss.str());
    ss.str("");
  }
}
