﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/emr-containers/model/ContainerLogRotationConfiguration.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace EMRContainers {
namespace Model {

ContainerLogRotationConfiguration::ContainerLogRotationConfiguration(JsonView jsonValue) { *this = jsonValue; }

ContainerLogRotationConfiguration& ContainerLogRotationConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("rotationSize")) {
    m_rotationSize = jsonValue.GetString("rotationSize");
    m_rotationSizeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("maxFilesToKeep")) {
    m_maxFilesToKeep = jsonValue.GetInteger("maxFilesToKeep");
    m_maxFilesToKeepHasBeenSet = true;
  }
  return *this;
}

JsonValue ContainerLogRotationConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_rotationSizeHasBeenSet) {
    payload.WithString("rotationSize", m_rotationSize);
  }

  if (m_maxFilesToKeepHasBeenSet) {
    payload.WithInteger("maxFilesToKeep", m_maxFilesToKeep);
  }

  return payload;
}

}  // namespace Model
}  // namespace EMRContainers
}  // namespace Aws
