﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/finspace/model/GetKxChangesetResult.h>

#include <utility>

using namespace Aws::finspace::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetKxChangesetResult::GetKxChangesetResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetKxChangesetResult& GetKxChangesetResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("changesetId")) {
    m_changesetId = jsonValue.GetString("changesetId");
    m_changesetIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("databaseName")) {
    m_databaseName = jsonValue.GetString("databaseName");
    m_databaseNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("environmentId")) {
    m_environmentId = jsonValue.GetString("environmentId");
    m_environmentIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("changeRequests")) {
    Aws::Utils::Array<JsonView> changeRequestsJsonList = jsonValue.GetArray("changeRequests");
    for (unsigned changeRequestsIndex = 0; changeRequestsIndex < changeRequestsJsonList.GetLength(); ++changeRequestsIndex) {
      m_changeRequests.push_back(changeRequestsJsonList[changeRequestsIndex].AsObject());
    }
    m_changeRequestsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdTimestamp")) {
    m_createdTimestamp = jsonValue.GetDouble("createdTimestamp");
    m_createdTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("activeFromTimestamp")) {
    m_activeFromTimestamp = jsonValue.GetDouble("activeFromTimestamp");
    m_activeFromTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("lastModifiedTimestamp")) {
    m_lastModifiedTimestamp = jsonValue.GetDouble("lastModifiedTimestamp");
    m_lastModifiedTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("status")) {
    m_status = ChangesetStatusMapper::GetChangesetStatusForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("errorInfo")) {
    m_errorInfo = jsonValue.GetObject("errorInfo");
    m_errorInfoHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
